//
//  ABPerson+CSVExport.m
//  A to G (formerly AddressBookToCSV)
//
//  Created by Ken Ferry on Thu Jun 17 2004.
//  Copyright (c) 2006 Ben Borofka. All rights reserved.
//

#import "ABPerson+CSVExport.h"


@implementation ABPerson (CSVExport)

- (NSString *)firstName
{
    return [self valueForProperty:kABFirstNameProperty];
}

- (NSString *)lastName
{
    return [self valueForProperty:kABLastNameProperty];
}

- (NSString *)fullName
{
    NSString *firstName, *lastName, *fullName;
    
    firstName = [self firstName];
    lastName = [self lastName];
        
    if (firstName && lastName)
    {
        ABAddressBook *addressBook = [ABAddressBook sharedAddressBook];        
        BOOL lastNameFirst;

        if ([addressBook respondsToSelector:@selector(defaultNameOrdering)]) // 10.3 and later
        {
            int defaultNameOrdering = (int)[addressBook defaultNameOrdering];
            int flags = [[self valueForProperty:kABPersonFlags] intValue] & kABNameOrderingMask;
            if (flags == kABDefaultNameOrdering)
            {
                flags = defaultNameOrdering;
            }
            
            if (flags == kABLastNameFirst)
            {
                lastNameFirst = YES;
            }
            else
            {
                lastNameFirst = NO;
            }
        }
        else
        {
            lastNameFirst = NO;
        }
        
        if (lastNameFirst)
        {
            fullName = [lastName stringByAppendingFormat:@" %@", firstName, nil];
        }
        else
        {
            fullName = [firstName stringByAppendingFormat:@" %@", lastName, nil];
        }
    }
    
    else if (firstName)
    {
        fullName = firstName;
    }
    else
    {
        fullName = lastName;
    }
        
    return fullName;
}

- (BOOL)isCompany
{
    return [[self valueForProperty:kABPersonFlags] intValue] & kABShowAsCompany;
}

- (NSString *)companyName
{
    return [self valueForProperty:kABOrganizationProperty];
}

- (NSString *)primaryEmail
{
	NSLog(@"primaryEmail");
	
	ABMultiValue *emails = [self valueForProperty:kABEmailProperty]; 
	id value = [emails valueAtIndex:[emails indexForIdentifier:[emails primaryIdentifier]]];

	return (NSString *)value;
}

- (NSString *)homeEmail	
{
	NSLog(@"homeEmail");
	
	ABMultiValue *emails = [self valueForProperty:kABEmailProperty];
	unsigned i;
	int count = [emails count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [emails labelAtIndex:i];
		if ([label isEqualToString:kABEmailHomeLabel] && [[emails valueAtIndex:i] isNotEqualTo:[self primaryEmail]]) return [emails valueAtIndex:i];
	
	}
	return nil;
} 


- (NSString *)homeIM
{
	NSLog(@"homeIM");
	
	ABMultiValue *IMs = [self valueForProperty:kABAIMInstantProperty]; 
	unsigned i;
	int count = [IMs count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [IMs labelAtIndex:i];
		if ([label isEqualTo:kABAIMHomeLabel] || [label isEqualTo:kABJabberHomeLabel] || [label isEqualTo:kABMSNHomeLabel] || [label isEqualTo:kABYahooHomeLabel] || [label isEqualTo:kABICQHomeLabel]) return [IMs valueAtIndex:i];	// Return the first IM that ISN'T "Work" label
	}
	return nil;
}

- (NSString *)homePhone
{
	
	NSLog(@"homePhone");
	
	ABMultiValue *phones = [self valueForProperty:kABPhoneProperty]; 
	unsigned i;
	int count = [phones count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [phones labelAtIndex:i];
		if ([label isEqualToString:kABPhoneHomeLabel]) return [phones valueAtIndex:i];
		
	}
	return nil;
}

- (NSString *)mobilePhone
{
	
	NSLog(@"mobilePhone");
	
	ABMultiValue *phones = [self valueForProperty:kABPhoneProperty]; 
	unsigned i;
	int count = [phones count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [phones labelAtIndex:i];
		if ([label isEqualToString:kABPhoneMobileLabel]) return [phones valueAtIndex:i];
		
	}
	return nil;
}

- (NSString *)pagerPhone
{
	
	NSLog(@"pagerPhone");
	
	ABMultiValue *phones = [self valueForProperty:kABPhoneProperty]; 
	unsigned i;
	int count = [phones count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [phones labelAtIndex:i];
		if ([label isEqualToString:kABPhonePagerLabel]) return [phones valueAtIndex:i];
		
	}
	return nil;
}

- (NSString *)homeFax
{
	
	NSLog(@"homeFax");
	
	ABMultiValue *phones = [self valueForProperty:kABPhoneProperty]; 
	unsigned i;
	int count = [phones count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [phones labelAtIndex:i];
		if ([label isEqualToString:kABPhoneHomeFAXLabel]) return [phones valueAtIndex:i];
		
	}
	return nil;
}

- (NSString *)homeAddress
{
	NSLog(@"homeAddress");
	
	ABMultiValue *addresses = [self valueForProperty:kABAddressProperty]; 
	NSDictionary *homeAddress = [NSDictionary dictionary];
	unsigned i;
	int count = [addresses count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [addresses labelAtIndex:i];
		if ([label isEqualToString:kABAddressHomeLabel])
		{
		
			homeAddress = [addresses valueAtIndex:i];
			NSMutableString *addressString = [NSMutableString stringWithString:[NSString stringWithFormat:@"%@\n%@ %@ %@\n%@", 
				[homeAddress valueForKey:kABAddressStreetKey], [homeAddress valueForKey:kABAddressCityKey], [homeAddress valueForKey:kABAddressStateKey], [homeAddress valueForKey:kABAddressZIPKey], [homeAddress valueForKey:kABAddressCountryKey]]];
			return addressString;
		
		}
	}
	return nil;
}

- (NSString *)workEmail	
{
	NSLog(@"workEmail");
	
	ABMultiValue *emails = [self valueForProperty:kABEmailProperty];
	unsigned i;
	int count = [emails count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [emails labelAtIndex:i];
		if ([label isEqualToString:kABEmailWorkLabel] && [[emails valueAtIndex:i] isNotEqualTo:[self primaryEmail]]) return [emails valueAtIndex:i];
		
	}
	return nil;
} 

- (NSString *)workIM
{
	NSLog(@"workIM");
	
	ABMultiValue *IMs = [self valueForProperty:kABAIMInstantProperty]; 	
	unsigned i;
	int count = [IMs count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [IMs labelAtIndex:i];
		if ([label isEqualTo:kABAIMWorkLabel] || [label isEqualTo:kABJabberWorkLabel] || [label isEqualTo:kABMSNWorkLabel] || [label isEqualTo:kABYahooWorkLabel] || [label isEqualTo:kABICQWorkLabel]) return [IMs valueAtIndex:i];	// Return the first IM that ISN'T "Home"
		
	}
	return nil;
}

- (NSString *)workPhone
{
	
	NSLog(@"workPhone");
	
	ABMultiValue *phones = [self valueForProperty:kABPhoneProperty]; 
	unsigned i;
	int count = [phones count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [phones labelAtIndex:i];
		if ([label isEqualToString:kABPhoneWorkLabel]) return [phones valueAtIndex:i];
		
	}
	return nil;
}

- (NSString *)workFax
{
	
	NSLog(@"workFax");
	
	ABMultiValue *phones = [self valueForProperty:kABPhoneProperty]; 
	unsigned i;
	int count = [phones count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [phones labelAtIndex:i];
		if ([label isEqualToString:kABPhoneWorkFAXLabel]) return [phones valueAtIndex:i];
		
	}
	return nil;
}

- (NSString *)workAddress
{
	
	NSLog(@"workAddress");
	
	ABMultiValue *addresses = [self valueForProperty:kABAddressProperty]; 
	NSDictionary *workAddress = [NSDictionary dictionary];
	unsigned i;
	int count = [addresses count];
	
	for (i = 0; i < count; i++) 
	{
		NSString *label = [addresses labelAtIndex:i];
		if ([label isEqualToString:kABAddressWorkLabel])
		{
			workAddress = [addresses valueAtIndex:i];
			NSMutableString *addressString = [NSMutableString stringWithString:[NSString stringWithFormat:@"%@\n%@ %@ %@\n%@", 
				[workAddress valueForKey:kABAddressStreetKey], [workAddress valueForKey:kABAddressCityKey], [workAddress valueForKey:kABAddressStateKey], [workAddress valueForKey:kABAddressZIPKey], [workAddress valueForKey:kABAddressCountryKey]]];
			return addressString;
			
		}
	}
	return nil;
	
}

@end
